# Intuition
<!-- Describe your first thoughts on how to solve this problem. -->
Think a little and this becomes our classical binary search.

OR

Think of function having time complexity $$O( logn)$$ and related to searching index - this also leads us to binary search.

# Approach
<!-- Describe your approach to solving the problem. -->
Implementing binary search : 

- Keep two pointers - one at start and one and end of array index
- Now consider the middle index element, 
-  - if it is greater than it's right element then peak will be present in left half of array
- - otherwise the peak will be present in right half
- keep iterating until right and left pointers meet/cross each other

The last leftmost pointer's index will be the peak.

Have a look at the code , still have any confusion then please let me know in the comments
Keep Solving.:)
# Complexity
- Time complexity : $$O( logn)$$
<!-- Add your time complexity here, e.g. $$O(n)$$ -->

- Space complexity : $$O( 1)$$
<!-- Add your space complexity here, e.g. $$O(n)$$ -->

# Code
```
class Solution {
    public int peakIndexInMountainArray(int[] arr) {
        int l = 0; 
        int r = arr.length - 1;

        while( l < r){
            int mid = ( l + r)/2;
            if( arr[mid] >= arr[mid + 1]){
                r = mid;
            }
            else{
                l = mid + 1;
            }
        }
        return l;
    }
}
```